/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.capabilities;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractTile;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractReference;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CombinedItemHandler
implements IItemHandler {
    private final Channel channel;
    private final TesseractTile requester;

    public CombinedItemHandler(Channel channel, TesseractTile requester) {
        this.channel = channel;
        this.requester = requester;
    }

    public int getSlots() {
        if (this.pushRecurrentCall()) {
            return 0;
        }
        int slots = 0;
        for (TesseractReference reference : this.channel.tesseracts) {
            TesseractTile tile;
            if (!reference.isValid() || (tile = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : tile.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                slots += handler.getSlots();
            }
        }
        this.popRecurrentCall();
        return slots;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.pushRecurrentCall()) {
            return ItemStack.f_41583_;
        }
        int slots = 0;
        for (TesseractReference reference : this.channel.tesseracts) {
            TesseractTile tile;
            if (!reference.isValid() || (tile = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : tile.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                if (slot - slots < handler.getSlots()) {
                    ItemStack stack = handler.getStackInSlot(slot - slots);
                    this.popRecurrentCall();
                    return stack;
                }
                slots += handler.getSlots();
            }
        }
        this.popRecurrentCall();
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.pushRecurrentCall()) {
            return stack;
        }
        if (!this.requester.canSend(EnumChannelType.ITEMS) || stack.m_41619_()) {
            return stack;
        }
        int slots = 0;
        for (TesseractReference reference : this.channel.tesseracts) {
            TesseractTile tile;
            if (!reference.isValid() || (tile = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : tile.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                if (slot - slots < handler.getSlots()) {
                    ItemStack leftOver = reference.canReceive(EnumChannelType.ITEMS) ? handler.insertItem(slot - slots, stack, simulate) : stack;
                    this.popRecurrentCall();
                    return leftOver;
                }
                slots += handler.getSlots();
            }
        }
        this.popRecurrentCall();
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.pushRecurrentCall()) {
            return ItemStack.f_41583_;
        }
        if (!this.requester.canReceive(EnumChannelType.ITEMS) || amount <= 0) {
            return ItemStack.f_41583_;
        }
        int slots = 0;
        for (TesseractReference reference : this.channel.tesseracts) {
            TesseractTile tile;
            if (!reference.isValid() || (tile = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : tile.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                if (slot - slots < handler.getSlots()) {
                    ItemStack stack = reference.canSend(EnumChannelType.ITEMS) ? handler.extractItem(slot - slots, amount, simulate) : ItemStack.f_41583_;
                    this.popRecurrentCall();
                    return stack;
                }
                slots += handler.getSlots();
            }
        }
        this.popRecurrentCall();
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        if (this.pushRecurrentCall()) {
            return 0;
        }
        int slots = 0;
        for (TesseractReference reference : this.channel.tesseracts) {
            TesseractTile tile;
            if (!reference.isValid() || (tile = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : tile.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                if (slot - slots < handler.getSlots()) {
                    int limit = handler.getSlotLimit(slot - slots);
                    this.popRecurrentCall();
                    return limit;
                }
                slots += handler.getSlots();
            }
        }
        this.popRecurrentCall();
        return 0;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (this.pushRecurrentCall()) {
            return false;
        }
        int slots = 0;
        for (TesseractReference reference : this.channel.tesseracts) {
            TesseractTile tile;
            if (!reference.isValid() || (tile = reference.getTesseract()) == this.requester) continue;
            for (IItemHandler handler : tile.getSurroundingCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
                if (slot - slots < handler.getSlots()) {
                    boolean valid = handler.isItemValid(slot - slots, stack);
                    this.popRecurrentCall();
                    return valid;
                }
                slots += handler.getSlots();
            }
        }
        this.popRecurrentCall();
        return false;
    }

    private boolean pushRecurrentCall() {
        if (this.requester.recurrentCalls >= 1) {
            return true;
        }
        ++this.requester.recurrentCalls;
        return false;
    }

    private void popRecurrentCall() {
        --this.requester.recurrentCalls;
    }
}

